//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define macroRandom (rand() / (double)SHORT_MAX)
#define macroSigmoid(a) (1.0 / (1 + MathExp(-a)))
//+------------------------------------------------------------------+
#define def_Fast
//+------------------------------------------------------------------+
double   _OR[][3] {
                    {0, 0, 0},
                    {0, 1, 1},
                    {1, 0, 1},
                    {1, 1, 1},
                  };
double  _AND[][3] {
                    {0, 0, 0},
                    {0, 1, 0},
                    {1, 0, 0},
                    {1, 1, 1},
                  };
double _NAND[][3] {
                    {0, 0, 1},
                    {0, 1, 1},
                    {1, 0, 1},
                    {1, 1, 0},
                  };
//+------------------------------------------------------------------+
enum ePort {OR, AND, NAND};
//+------------------------------------------------------------------+
#define nTrain (_OR.Size() / 3)
const double eps = 1e-3;
//+------------------------------------------------------------------+
struct st_XOR
{
    struct si
    {
        double w0, w1, b, Err;
        double learning[nTrain][3];
    }Port[NAND + 1];
}_XOR;
//+------------------------------------------------------------------+
double Cost(const double w0, const double w1, const double b, const double &Train[][])
{
    double err;

    err = 0;
    for (uint c = 0; c < nTrain; c++)
        err += MathPow((macroSigmoid((Train[c][0] * w0) + (Train[c][1] * w1) + b) - Train[c][2]), 2);

    return err / nTrain;
}
//+------------------------------------------------------------------+
void OnStart()
{
#define Machine_Learning for(ePort c = OR; c <= NAND; c++)

    double ew0, ew1, eb;
    ulong count, it0, it1;

    Print("The Neuron - Tutor...");
    MathSrand(512);
    
    for (ePort c = OR; c < NAND; c++)
    {
        _XOR.Port[c].w0 = (double)macroRandom;
        _XOR.Port[c].w1 = (double)macroRandom;
        _XOR.Port[c].b = (double)macroRandom;
    }
    ArrayCopy(_XOR.Port[OR].learning, _OR);
    ArrayCopy(_XOR.Port[AND].learning, _AND);
    ArrayCopy(_XOR.Port[NAND].learning, _NAND);

    it0 = GetTickCount();

    for (count = 0; count < ULONG_MAX; count++)
    {
        Machine_Learning _XOR.Port[c].Err = Cost(_XOR.Port[c].w0, _XOR.Port[c].w1, _XOR.Port[c].b, _XOR.Port[c].learning);

        if ((_XOR.Port[OR].Err < eps) && (_XOR.Port[AND].Err < eps) && (_XOR.Port[NAND].Err < eps))
            break;

        Machine_Learning {
            ew0 = ((Cost(_XOR.Port[c].w0 + eps, _XOR.Port[c].w1, _XOR.Port[c].b, _XOR.Port[c].learning) - _XOR.Port[c].Err) / eps);
            ew1 = ((Cost(_XOR.Port[c].w0, _XOR.Port[c].w1 + eps, _XOR.Port[c].b, _XOR.Port[c].learning) - _XOR.Port[c].Err) / eps);
            eb  = ((Cost(_XOR.Port[c].w0, _XOR.Port[c].w1, _XOR.Port[c].b + eps, _XOR.Port[c].learning) - _XOR.Port[c].Err) / eps);

            _XOR.Port[c].w0 -= (ew0 * eps);
            _XOR.Port[c].w1 -= (ew1 * eps);
            _XOR.Port[c].b  -= (eb * eps);
        }
    }

    it1 = GetTickCount();
    Print("Time: ", (it1 - it0) / 1000.0, " seconds.");
    PrintFormat("Interactions: %I64u", count);
    Machine_Learning {
        Print(EnumToString(c) + " port Information: ");
        Print("w0: ", _XOR.Port[c].w0, " w1: ", _XOR.Port[c].w1, " bias: ", _XOR.Port[c].b, " Error: ", _XOR.Port[c].Err);
    }

    Print("Testing the neuron...");
    for (uchar p0 = 0; p0 < 2; p0++)
        for (uchar p1 = 0; p1 < 2; p1++)
            PrintFormat("%d XOR %d IS %f", p0, p1, macroSigmoid((_XOR.Port[AND].w0 * macroSigmoid((p0 * _XOR.Port[NAND].w0) + (p1 * _XOR.Port[NAND].w1) + _XOR.Port[NAND].b)) + 
                                                                (_XOR.Port[AND].w1 * macroSigmoid((p0 * _XOR.Port[OR].w0) + (p1 * _XOR.Port[OR].w1) + _XOR.Port[OR].b)) + _XOR.Port[AND].b));


    Print("************************************");
}
//+------------------------------------------------------------------+